/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.inventory.container;

import cofh.core.inventory.container.TileContainer;
import cofh.core.network.packet.server.ContainerPacket;
import cofh.lib.inventory.container.ContainerCoFH;
import cofh.lib.inventory.container.slot.SlotCoFH;
import cofh.lib.inventory.wrapper.InvWrapperCoFH;
import cofh.lib.inventory.wrapper.InvWrapperItem;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.core.block.entity.TinkerBenchTile;
import cofh.thermal.core.init.TCoreReferences;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TinkerBenchContainer
extends TileContainer {
    public final TinkerBenchTile tile;
    protected SlotCoFH tinkerSlot;
    protected List<SlotCoFH> tinkerAugmentSlots = new ArrayList<SlotCoFH>(9);
    protected InvWrapperItem itemInventory = new InvWrapperItem((AbstractContainerMenu)this, 9){

        public boolean m_7013_(int index, ItemStack stack) {
            return TinkerBenchContainer.this.tile.allowAugmentation() && TinkerBenchContainer.this.tinkerSlot.m_6657_() && index < AugmentableHelper.getAugmentSlots((ItemStack)TinkerBenchContainer.this.tinkerSlot.m_7993_()) && AugmentableHelper.validAugment((ItemStack)TinkerBenchContainer.this.tinkerSlot.m_7993_(), (ItemStack)stack, (List)TinkerBenchContainer.this.itemInventory.getStacks());
        }
    };

    public TinkerBenchContainer(int windowId, Level world, BlockPos pos, Inventory inventory, Player player) {
        super(TCoreReferences.TINKER_BENCH_CONTAINER, windowId, world, pos, inventory, player);
        this.tile = (TinkerBenchTile)world.m_7702_(pos);
        InvWrapperCoFH tileInv = new InvWrapperCoFH(this.tile.getItemInv());
        this.allowSwap = false;
        this.tinkerSlot = new SlotCoFH(tileInv, 0, 44, 26){

            public void m_142406_(Player thePlayer, ItemStack stack) {
                TinkerBenchContainer.this.writeAugmentsToItem(stack);
                TinkerBenchContainer.this.itemInventory.m_6211_();
                super.m_142406_(thePlayer, stack);
            }

            public void m_5852_(ItemStack stack) {
                if (TinkerBenchContainer.this.syncing) {
                    super.m_5852_(stack);
                    return;
                }
                ItemStack curStack = TinkerBenchContainer.this.tinkerSlot.m_7993_();
                if (!curStack.m_41619_() && !curStack.equals(stack)) {
                    TinkerBenchContainer.this.writeAugmentsToItem(curStack);
                }
                super.m_5852_(stack);
                if (!stack.m_41619_()) {
                    TinkerBenchContainer.this.readAugmentsFromItem(stack);
                }
            }
        };
        this.m_38897_((Slot)this.tinkerSlot);
        this.m_38897_((Slot)new SlotCoFH(tileInv, 1, 8, 53));
        this.m_38897_((Slot)new SlotCoFH(tileInv, 2, 152, 53));
        this.bindAugmentSlots((Container)tileInv, 3, this.tile.augSize());
        this.bindTinkerSlots((Container)this.itemInventory, 0, 9);
        this.bindPlayerInventory(inventory);
        this.readAugmentsFromItem(this.tinkerSlot.m_7993_());
    }

    private void readAugmentsFromItem(ItemStack stack) {
        if (!stack.m_41619_()) {
            this.itemInventory.setInvContainer(stack, AugmentableHelper.getAugments((ItemStack)stack), AugmentableHelper.getAugmentSlots((ItemStack)stack));
        }
    }

    private void writeAugmentsToItem(ItemStack stack) {
        if (!stack.m_41619_()) {
            this.tile.setPause(true);
            AugmentableHelper.setAugments((ItemStack)stack, (List)this.itemInventory.getStacks());
            this.tile.setPause(false);
        }
    }

    private void bindTinkerSlots(Container inventory, int startIndex, int numSlots) {
        for (int i = 0; i < numSlots; ++i) {
            SlotCoFH slot = new SlotCoFH(inventory, i + startIndex, 0, 0, 1){

                public boolean m_8010_(Player player) {
                    return TinkerBenchContainer.this.tile.allowAugmentation();
                }
            };
            this.tinkerAugmentSlots.add(slot);
            this.m_38897_((Slot)slot);
        }
        ((ArrayList)this.tinkerAugmentSlots).trimToSize();
    }

    public void onModeChange() {
        ContainerPacket.sendToServer((ContainerCoFH)this);
    }

    public boolean isTinkerSlot(Slot slot) {
        return this.tinkerSlot.equals(slot);
    }

    public int getNumTinkerAugmentSlots() {
        return AugmentableHelper.getAugmentSlots((ItemStack)this.tinkerSlot.m_7993_());
    }

    public List<SlotCoFH> getTinkerAugmentSlots() {
        return this.tinkerAugmentSlots;
    }

    public void m_6877_(Player playerIn) {
        this.writeAugmentsToItem(this.tinkerSlot.m_7993_());
        super.m_6877_(playerIn);
    }

    public ItemStack m_7648_(Player player, int index) {
        if (index == this.tinkerSlot.getSlotIndex()) {
            this.writeAugmentsToItem(this.tinkerSlot.m_7993_());
        }
        return super.m_7648_(player, index);
    }

    public void handleContainerPacket(FriendlyByteBuf buffer) {
        this.writeAugmentsToItem(this.tinkerSlot.m_7993_());
        this.tile.toggleTinkerSlotMode();
    }
}

